package com.xunyi.beast.web.servlet.error;

import com.xunyi.beast.data.message.*;
import com.xunyi.beast.web.support.ServerExchangeUtils;
import feign.FeignException;
import feign.Request;
import feign.RetryableException;
import lombok.extern.slf4j.Slf4j;
import org.apache.catalina.connector.Response;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

@Slf4j
@RestControllerAdvice
public class ConstraintExceptionAdvice {

//    @ExceptionHandler(ConstraintViolationException.class)
//    public @ResponseBody
//    Return constraintViolationException(ConstraintViolationException cve) {
//        Set<ConstraintViolation<?>> cvs = cve.getConstraintViolations();
//        Iterator<ConstraintViolation<?>> cvIterator = cvs.iterator();
//        ConstraintViolation<?> cs = cvIterator.next();
//        String message = cs.getMessage();
//        return errorOfMessage(message, StandardErrors.BAD_PARAMETER).toReturn(cs.getPropertyPath().toString());
//    }
//


    protected IError errorOfMessage(String message, IError defaultError) {
        //TODO 预留处理
        return defaultError;
//        throw new UnsupportedOperationException();
//        try {
//            return errorOfCode(message);
//        } catch (Throwable e) {
//            log.warn("not match error message: ", e);
//            return defaultError;
//        }
    }

    private ErrorMessageSource errorMessageSource;

    public ConstraintExceptionAdvice(ErrorMessageSource errorMessageSource) {
        this.errorMessageSource = errorMessageSource;
    }
    @ExceptionHandler({
            MissingServletRequestParameterException.class,
            MethodArgumentTypeMismatchException.class
    })
    public ModelAndView missingRequestParameter(
            HttpServletRequest request, HttpServletResponse response,
            Exception e
    ) throws IOException {
        String code = null;
        Object[] args = null;
        if (e instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException missingServletRequestParameterException = (MissingServletRequestParameterException) e;
            String missingParameterName = missingServletRequestParameterException.getParameterName();
            String missingParameterType = missingServletRequestParameterException.getParameterType();
            code = StandardErrors.PARAMETER_MISSING.getErrorCode();
            args = new Object[]{missingParameterType, missingParameterName};

        } else if (e instanceof MethodArgumentTypeMismatchException) {
            MethodArgumentTypeMismatchException methodArgumentTypeMismatchException = (MethodArgumentTypeMismatchException) e;
            code = StandardErrors.PARAMETER_TYPE_MISMATCH.getErrorCode();
            String requiredType = Objects.requireNonNull(methodArgumentTypeMismatchException.getRequiredType()).getSimpleName();
            args = new Object[]{methodArgumentTypeMismatchException.getName(), requiredType};
        }
        String message = errorMessageSource.getMessage(code, args);
        request.setAttribute(ServerExchangeUtils.ERROR_ATTR, code);
        request.setAttribute(ServerExchangeUtils.MESSAGE_ATTR, message);
        response.sendError(Response.SC_OK);
        return new ModelAndView();
    }

    @ExceptionHandler({
            ConstraintViolationException.class
    })
    public ModelAndView constraintViolationException(HttpServletRequest request, HttpServletResponse response, ConstraintViolationException cve) throws IOException {
        Set<ConstraintViolation<?>> cvs = cve.getConstraintViolations();
        Iterator<ConstraintViolation<?>> cvIterator = cvs.iterator();
        ConstraintViolation<?> cs = cvIterator.next();
        String message = cs.getMessage();
        IError error = errorOfMessage(message, StandardErrors.BAD_PARAMETER.toError());
        request.setAttribute(ServerExchangeUtils.ERROR_ATTR, error.getCode());
        response.sendError(Response.SC_OK);
        return new ModelAndView();
    }



}
