package com.xunyi.beast.web.mvc;

import com.xunyi.beast.data.message.Return;
import com.xunyi.beast.data.message.Returns;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerTypePredicate;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import java.util.Objects;

@RestControllerAdvice
public class ReturnResponseBodyAdvice implements ResponseBodyAdvice<Object> {

    private HandlerTypePredicate handlerTypePredicate;

    public ReturnResponseBodyAdvice() {

    }

    public void setHandlerTypePredicate(HandlerTypePredicate handlerTypePredicate) {
        this.handlerTypePredicate = handlerTypePredicate;
    }

    public boolean isApplicableToBeanType(@Nullable Class<?> beanType) {
        return this.handlerTypePredicate.test(beanType);
    }

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        var declaringClass = returnType.getDeclaringClass();
        if (!isApplicableToBeanType(declaringClass)) {
            return false;
        }
        if (AnnotatedElementUtils.hasMetaAnnotationTypes(declaringClass, IgnoreReturnResponse.class)) {
            return false;
        }
        var method = Objects.requireNonNull(returnType.getMethod());
        if (method.isAnnotationPresent(IgnoreReturnResponse.class)) {
            return false;
        }
        if (AnnotatedElementUtils.hasMetaAnnotationTypes(declaringClass, ResponseBody.class)) {
            return true;
        }
        return method.isAnnotationPresent(ResponseBody.class);
    }

    @Override
    public Object beforeBodyWrite(@Nullable Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof Return || body instanceof ResponseEntity){
            return body;
        } else {
            return Returns.ok(body);
        }
    }
}
