/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.web.converter.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.xunyi.beast.data.message.jackson.MessageModule;
import com.xunyi.beast.data.money.jackson.MoneyModule;
import com.xunyi.beast.data.mongo.MongoModule;
import com.xunyi.beast.data.page.PageSerializer;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Page;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
@ConditionalOnClass(value={ObjectMapper.class})
@AutoConfigureBefore(value={JacksonAutoConfiguration.class})
public class JacksonCustomAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class})
    static class JacksonCustomizerConfiguration {
        JacksonCustomizerConfiguration() {
        }

        @Bean
        public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer() {
            return jacksonObjectMapperBuilder -> {
                jacksonObjectMapperBuilder.serializationInclusion(JsonInclude.Include.NON_NULL);
                jacksonObjectMapperBuilder.featuresToEnable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
                jacksonObjectMapperBuilder.featuresToDisable(new Object[]{SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS});
                jacksonObjectMapperBuilder.featuresToDisable(new Object[]{DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS});
            };
        }

        @ConditionalOnClass(value={Page.class})
        @Bean
        public Jackson2ObjectMapperBuilderCustomizer pageJackson2ObjectMapperBuilderCustomizer() {
            return jacksonObjectMapperBuilder -> jacksonObjectMapperBuilder.serializers(new JsonSerializer[]{new PageSerializer()});
        }

        @Bean
        @ConditionalOnBean(value={MessageSource.class})
        public MessageModule messageModule(MessageSource source) {
            return new MessageModule(source);
        }

        @Bean
        @ConditionalOnBean(value={MongoOperations.class})
        public MongoModule mongoModule() {
            return new MongoModule();
        }

        @Bean
        public MoneyModule moneyModule() {
            return new MoneyModule();
        }
    }
}

