/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.web.bind;

import com.xunyi.beast.data.message.ErrorException;
import com.xunyi.beast.data.message.IErrorOwner;
import com.xunyi.beast.data.message.Return;
import com.xunyi.beast.data.message.StandardErrors;
import com.xunyi.beast.token.web.InvalidXYTokenException;
import com.xunyi.beast.token.web.MissingXYTokenException;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public abstract class AbstractErrorControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(AbstractErrorControllerAdvice.class);

    public abstract IErrorOwner errorOfCode(String var1) throws Throwable;

    protected IErrorOwner errorOfMessage(String message, IErrorOwner defaultError) {
        try {
            return this.errorOfCode(message);
        }
        catch (Throwable e) {
            log.warn("not match error message: ", e);
            return defaultError;
        }
    }

    protected Return returnOfMessage(String message, IErrorOwner defaultError) {
        return this.errorOfMessage(message, defaultError).toReturn();
    }

    protected Return returnOfMessage(String message) {
        return this.returnOfMessage(message, (IErrorOwner)StandardErrors.UNKNOWN_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseBody
    public Return constraintViolationException(ConstraintViolationException cve) {
        Set cvs = cve.getConstraintViolations();
        Iterator cvIterator = cvs.iterator();
        ConstraintViolation cs = (ConstraintViolation)cvIterator.next();
        String message = cs.getMessage();
        return this.errorOfMessage(message, (IErrorOwner)StandardErrors.PARAMETER_BAD).toReturn(new Object[]{cs.getPropertyPath().toString()});
    }

    protected Return returnOfBindResult(BindingResult bindingResult) {
        FieldError fieldError = bindingResult.getFieldError();
        log.warn("returnOfBindResult: Field Error{}", (Object)fieldError);
        assert (fieldError != null);
        String message = fieldError.getDefaultMessage();
        return this.errorOfMessage(message, (IErrorOwner)StandardErrors.PARAMETER_BAD).toReturn(new Object[]{fieldError.getField()});
    }

    @ExceptionHandler(value={InvalidXYTokenException.class, MissingXYTokenException.class})
    @ResponseBody
    public Return handleInvalidXYToken(Exception e) {
        log.warn("XYTokenBindException: {}", (Object)e.getMessage(), (Object)e);
        return StandardErrors.XYTOKEN_INVALID.toReturn();
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public Return methodArgumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException e) {
        log.warn("request uri:[{}] exception:", (Object)request.getRequestURI(), (Object)e);
        return this.returnOfBindResult(e.getBindingResult());
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    @ResponseBody
    public Return handHttpMediaTypeException(HttpServletRequest request, HttpMediaTypeNotAcceptableException e) {
        log.warn("request uri:[{}] accept: [{}] supportedMediaType: [{}] exception:", new Object[]{request.getRequestURI(), request.getHeader("accept"), e.getSupportedMediaTypes(), e});
        return StandardErrors.HTTP_MEDIA_TYPE_NOT_ACCEPTABLE.toReturn();
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public Return handHttpRequestMethodNotSupportedException(HttpServletRequest request, HttpRequestMethodNotSupportedException e) {
        log.warn("request uri:[{}] method: [{}] supportedMediaType: [{}] exception:", new Object[]{request.getRequestURI(), e.getMethod(), e.getSupportedMethods(), e});
        return StandardErrors.HTTP_REQUEST_METHOD_NOT_SUPPORTED.toReturn();
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseBody
    public Return handleMethodArgumentTypeMismatchException(HttpServletRequest request, MethodArgumentTypeMismatchException e) {
        log.warn("request uri:[{}] name: {} exception:", new Object[]{request.getRequestURI(), e.getName(), e});
        return StandardErrors.PARAMETER_BAD.toReturn(new Object[]{e.getName()});
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public Return handleMissingRequestParameter(HttpServletRequest request, MissingServletRequestParameterException e) {
        log.warn("request uri:[{}] name: {} exception:", new Object[]{request.getRequestURI(), e.getParameterName(), e});
        return StandardErrors.PARAMETER_BAD.toReturn(new Object[]{e.getParameterName()});
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public Return bindException(HttpServletRequest request, BindException e) {
        log.warn("request uri:[{}] exception:", (Object)request.getRequestURI(), (Object)e);
        return this.returnOfBindResult(e.getBindingResult());
    }

    @ExceptionHandler(value={UnsatisfiedServletRequestParameterException.class})
    @ResponseBody
    public Return handleUnsatisfiedServletRequestParameterException(HttpServletRequest request, UnsatisfiedServletRequestParameterException e) {
        log.warn("request uri:[{}] exception: {}", new Object[]{request.getRequestURI(), e.getMessage(), e});
        return StandardErrors.PARAMETER_BAD.toReturn();
    }

    @ExceptionHandler(value={ErrorException.class})
    @ResponseBody
    public Return handleErrorException(ErrorException e) {
        log.warn("handle ErrorException error:{}", (Object)e.getError(), (Object)e);
        return e.toReturn();
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Return handleException(Exception e) {
        log.error("handleException message: {}", (Object)e.getMessage(), (Object)e);
        return StandardErrors.UNKNOWN_ERROR.toReturn();
    }
}

