package com.xunyi.beast.token.user;


import com.xunyi.beast.token.TokenNamed;
import com.xunyi.beast.token.exception.TokenExpiredException;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.time.Instant;

/**
 * 用户凭据
 * 统一cookie命名  u-token
 */
@Getter @Setter @EqualsAndHashCode
public class UserToken implements TokenNamed {

    private String appId;

    private long uid;

    private Instant issuedAt;

    private Instant expiresAt;



    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }
    public void verify() {
        Instant now = Instant.now();
        if (!this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new TokenExpiredException(msg);
        };
    }
}
