package com.xunyi.beast.token.support;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.xunyi.beast.token.user.WechatUserToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;

@Slf4j
public abstract class SimpleTokenCodec<T> implements TokenCodec<T>{

    private final Class<T> tokenClazz;
    private final static String CIPHER_TRANSFORMATION = "DESede/ECB/PKCS5Padding";
    private final static String ALGORITHM = "DESede";
    private final static String HEX_KEY = "d983bf671c70409429cedce33801049198a88a621315ce92";

    private static Key SECRET_KEY;

    public SimpleTokenCodec(Class<T> tokenClazz) {
        this.tokenClazz = tokenClazz;
    }

    static  {
        try {
            byte[] key = Hex.decodeHex(HEX_KEY);
            DESedeKeySpec deSedeKeySpec = new DESedeKeySpec(key);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            SECRET_KEY = secretKeyFactory.generateSecret(deSedeKeySpec);
        } catch (DecoderException | NoSuchAlgorithmException | InvalidKeyException | InvalidKeySpecException e) {
            e.printStackTrace();
        }
    }

    private static final ThreadLocal<Cipher> encryptCipherThreadLocal = ThreadLocal.withInitial(() -> {
        Cipher encryptCipher = null;
        try {
            encryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            encryptCipher.init(Cipher.ENCRYPT_MODE, SECRET_KEY);
        } catch (NoSuchAlgorithmException | InvalidKeyException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return encryptCipher;
    });
    private static ThreadLocal<Cipher> decryptCipherThreadLocal = ThreadLocal.withInitial(() -> {
        Cipher decryptCipher = null;
        try {
            decryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            decryptCipher.init(Cipher.DECRYPT_MODE, SECRET_KEY);
        } catch (NoSuchAlgorithmException | InvalidKeyException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        return decryptCipher;
    });

    private static ObjectMapper MAPPER = new ObjectMapper();
    static {
        MAPPER.registerModule(new JavaTimeModule());
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        MAPPER.configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
        MAPPER.configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
    }

    public String encode(T token) {
        try {
            byte[] data = MAPPER.writeValueAsBytes(token);
            Cipher encryptCipher = encryptCipherThreadLocal.get();
            return Hex.encodeHexString(encryptCipher.doFinal(data));
        } catch (Exception e) {
            log.warn("encode exception", e);
            throw new IllegalStateException();
        }
    }

    public T decode(String tokenString) {
        try {
            Cipher decryptCipher = decryptCipherThreadLocal.get();
            byte[] data = decryptCipher.doFinal(Hex.decodeHex(tokenString));
            return MAPPER.readValue(data, this.tokenClazz);
        } catch (Exception e) {
            log.warn("decode exception", e);
            throw new IllegalStateException();
        }
    }
}
