package com.xunyi.beast.token.support;

import com.xunyi.beast.token.EmailToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.SignatureAlgorithm;

import java.security.Key;
import java.time.Instant;
import java.util.Map;

public class EmailTokenJwt {

    private static final String PRIV_RESOURCE = "classpath:token/email-token-private.der";
    private static final String PUB_RESOURCE = "classpath:token/email-token-public.der";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;
    private static final class CLAIM_NAMES {
        private static final String EMAIL = "email";
        private static final String ISSUED_AT = "iss";
        private static final String EXPIRES_AT = "exp";
    }
    private EmailTokenJwt() { }

    public static class Parser extends JwtTokenHelper.AbstractTokenJwtParser<EmailToken> {

        public Parser() {
            this(JwtTokenHelper.readPublicKey(PUB_RESOURCE));
        }
        public Parser(Key key) {
            super(key);
        }

        @Override
        protected EmailToken read(Claims claims) {
            EmailToken token = new EmailToken();
            token.setEmail(claims.get(CLAIM_NAMES.EMAIL, String.class));
            token.setIssuedAt(Instant.ofEpochMilli(claims.get(CLAIM_NAMES.ISSUED_AT, Long.class)));
            token.setExpiresAt(Instant.ofEpochMilli(claims.get(CLAIM_NAMES.EXPIRES_AT, Long.class)));
            token.verify();
            return token;
        }
    }

    public static class Builder extends JwtTokenHelper.AbstractTokenJwtBuilder<EmailToken> {

        public Builder() {
            this(JwtTokenHelper.readPrivateKey(PRIV_RESOURCE),SIGNATURE_ALGORITHM);
        }

        public Builder(Key key, SignatureAlgorithm algorithm) {
            super(key, algorithm);
        }

        @Override
        protected void write(Map<String, Object> claims, EmailToken token) {
            claims.put(CLAIM_NAMES.EMAIL, token.getEmail());
            claims.put(CLAIM_NAMES.ISSUED_AT, token.getIssuedAt().toEpochMilli());
            claims.put(CLAIM_NAMES.EXPIRES_AT, token.getExpiresAt().toEpochMilli());
        }
    }




}
