/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.token.support;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.xunyi.beast.token.support.TokenCodec;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleTokenCodec<T>
implements TokenCodec<T> {
    private static final Logger log = LoggerFactory.getLogger(SimpleTokenCodec.class);
    private final Class<T> tokenClazz;
    private static final String CIPHER_TRANSFORMATION = "DESede/ECB/PKCS5Padding";
    private static final String ALGORITHM = "DESede";
    private static final String HEX_KEY = "d983bf671c70409429cedce33801049198a88a621315ce92";
    private static Key SECRET_KEY;
    private static final ThreadLocal<Cipher> encryptCipherThreadLocal;
    private static ThreadLocal<Cipher> decryptCipherThreadLocal;
    private static ObjectMapper MAPPER;

    public SimpleTokenCodec(Class<T> tokenClazz) {
        this.tokenClazz = tokenClazz;
    }

    @Override
    public String encode(T token) {
        try {
            byte[] data = MAPPER.writeValueAsBytes(token);
            Cipher encryptCipher = encryptCipherThreadLocal.get();
            return Hex.encodeHexString((byte[])encryptCipher.doFinal(data));
        }
        catch (Exception e) {
            log.warn("encode exception", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    @Override
    public T decode(String tokenString) {
        try {
            Cipher decryptCipher = decryptCipherThreadLocal.get();
            byte[] data = decryptCipher.doFinal(Hex.decodeHex((String)tokenString));
            return (T)MAPPER.readValue(data, this.tokenClazz);
        }
        catch (Exception e) {
            log.warn("decode exception", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    static {
        try {
            byte[] key = Hex.decodeHex((String)HEX_KEY);
            DESedeKeySpec deSedeKeySpec = new DESedeKeySpec(key);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            SECRET_KEY = secretKeyFactory.generateSecret(deSedeKeySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | DecoderException e) {
            e.printStackTrace();
        }
        encryptCipherThreadLocal = ThreadLocal.withInitial(() -> {
            Cipher encryptCipher = null;
            try {
                encryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
                encryptCipher.init(1, SECRET_KEY);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                e.printStackTrace();
            }
            return encryptCipher;
        });
        decryptCipherThreadLocal = ThreadLocal.withInitial(() -> {
            Cipher decryptCipher = null;
            try {
                decryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
                decryptCipher.init(2, SECRET_KEY);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                e.printStackTrace();
            }
            return decryptCipher;
        });
        MAPPER = new ObjectMapper();
        MAPPER.registerModule((Module)new JavaTimeModule());
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        MAPPER.configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
        MAPPER.configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
    }
}

