/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.token.support;

import com.google.common.collect.Maps;
import com.xunyi.beast.token.support.ITokenJwtBuilder;
import com.xunyi.beast.token.support.ITokenJwtParser;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.net.URL;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.util.ResourceUtils;

public abstract class JwtTokenHelper {
    public static PrivateKey readPrivateKey(String resource) {
        try {
            URL url = ResourceUtils.getURL((String)resource);
            byte[] keyBytes = IOUtils.toByteArray((URL)url);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static PublicKey readPublicKey(String resource) {
        try {
            URL url = ResourceUtils.getURL((String)resource);
            byte[] keyBytes = IOUtils.toByteArray((URL)url);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static abstract class AbstractTokenJwtBuilder<T>
    implements ITokenJwtBuilder<T> {
        private Key key;
        private SignatureAlgorithm algorithm;

        public AbstractTokenJwtBuilder(Key key, SignatureAlgorithm algorithm) {
            this.key = key;
            this.algorithm = algorithm;
        }

        protected abstract void write(Map<String, Object> var1, T var2);

        @Override
        public String compact(T token) {
            HashMap claims = Maps.newHashMap();
            this.write(claims, token);
            return Jwts.builder().signWith(this.key, this.algorithm).setClaims((Map)claims).compact();
        }
    }

    public static abstract class AbstractTokenJwtParser<T>
    implements ITokenJwtParser<T> {
        private Key key;

        public AbstractTokenJwtParser(Key key) {
            this.key = key;
        }

        protected abstract T read(Claims var1);

        @Override
        public T parse(String jwtString) {
            Jws jws = Jwts.parser().setSigningKey(this.key).parseClaimsJws(jwtString);
            Claims claims = (Claims)jws.getBody();
            return this.read(claims);
        }
    }
}

