/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.token.support;

import com.xunyi.beast.token.support.JwtTokenHelper;
import com.xunyi.beast.token.support.TokenCodec;
import com.xunyi.beast.token.user.UserToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.time.Instant;
import java.util.Map;

public class UserTokenCodec
implements TokenCodec<UserToken> {
    public static final String PRI_RESOURCE = "classpath:token/xy-token-private.der";
    public static final String PUB_RESOURCE = "classpath:token/xy-token-public.der";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;

    @Override
    public String encode(UserToken token) {
        return UserTokenBuilder.getInstance().compact(token);
    }

    @Override
    public UserToken decode(String tokenString) {
        return (UserToken)UserTokenParser.getInstance().parse(tokenString);
    }

    public static class UserTokenBuilder
    extends JwtTokenHelper.AbstractTokenJwtBuilder<UserToken> {
        private static final UserTokenBuilder INSTANCE = new UserTokenBuilder();

        public UserTokenBuilder() {
            this(JwtTokenHelper.readPrivateKey(UserTokenCodec.PRI_RESOURCE), SIGNATURE_ALGORITHM);
        }

        public UserTokenBuilder(Key key, SignatureAlgorithm algorithm) {
            super(key, algorithm);
        }

        @Override
        protected void write(Map<String, Object> claims, UserToken token) {
            claims.put("app", token.getAppId());
            claims.put("uid", token.getUid());
            claims.put("iss", token.getIssuedAt().toEpochMilli());
            claims.put("exp", token.getExpiresAt().toEpochMilli());
        }

        public static UserTokenBuilder getInstance() {
            return INSTANCE;
        }
    }

    public static class UserTokenParser
    extends JwtTokenHelper.AbstractTokenJwtParser<UserToken> {
        private static final UserTokenParser INSTANCE = new UserTokenParser();

        public UserTokenParser() {
            this(JwtTokenHelper.readPublicKey(UserTokenCodec.PUB_RESOURCE));
        }

        public UserTokenParser(Key key) {
            super(key);
        }

        @Override
        protected UserToken read(Claims claims) {
            UserToken token = new UserToken();
            String appId = (String)claims.get("app", String.class);
            Long uid = (Long)claims.get("uid", Long.class);
            Instant issuedAt = Instant.ofEpochMilli((Long)claims.get("iss", Long.class));
            Instant expiresAt = Instant.ofEpochMilli((Long)claims.get("exp", Long.class));
            token.setAppId(appId);
            token.setUid(uid);
            token.setIssuedAt(issuedAt);
            token.setExpiresAt(expiresAt);
            return token;
        }

        public static UserTokenParser getInstance() {
            return INSTANCE;
        }
    }

    private static final class CLAIM_NAMES {
        public static final String APP = "app";
        public static final String UID = "uid";
        public static final String ISSUED_AT = "iss";
        public static final String EXPIRES_AT = "exp";

        private CLAIM_NAMES() {
        }
    }
}

