package com.xunyi.beast.token.user;

import com.xunyi.beast.token.TokenNamed;
import lombok.Getter;
import lombok.Setter;

import java.time.Instant;

/**
 * 微信用户凭据 （写入cookie）
 * wx-token与UserToken是独立的，可以同时存在，且非绑定状态
 */
@Getter @Setter
public class WechatUserToken implements TokenNamed {


    /**
     * 微信公众号AppId
     */
    private String appId;

    /**
     * 微信-OpenId
     */
    private String openId;

    /**
     * 发行时间
     */
    private Instant issuedAt;

}
