package com.xunyi.beast.token.support;

import com.xunyi.beast.token.MobileToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.SignatureAlgorithm;

import java.security.Key;
import java.time.Instant;
import java.util.Map;

public class MobileTokenJwt {

    private static final String PRIV_RESOURCE = "classpath:token/mobile-token-private.der";
    private static final String PUB_RESOURCE = "classpath:token/mobile-token-public.der";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;
    private static final class CLAIM_NAMES {
        private static final String VERIFY_MODE = "verify-mode";
        private static final String MOBILE = "mobile";
        private static final String ISSUED_AT = "iss";
        private static final String EXPIRES_AT = "exp";
    }

    private MobileTokenJwt() { }

    public static class Parser extends JwtTokenHelper.AbstractTokenJwtParser<MobileToken> {

        public Parser() {
            this(JwtTokenHelper.readPublicKey(PUB_RESOURCE));
        }
        public Parser(Key key) {
            super(key);
        }

        @Override
        protected MobileToken read(Claims claims) {
            MobileToken token = new MobileToken();
            String verifyModeString = claims.get(CLAIM_NAMES.VERIFY_MODE, String.class);
            token.setVerifyMode(MobileToken.VerifyMode.valueOf(verifyModeString));
            token.setMobile(claims.get(CLAIM_NAMES.MOBILE, String.class));
            token.setIssuedAt(Instant.ofEpochMilli(claims.get(CLAIM_NAMES.ISSUED_AT, Long.class)));
            token.setExpiresAt(Instant.ofEpochMilli(claims.get(CLAIM_NAMES.EXPIRES_AT, Long.class)));
            token.verify();
            return token;
        }
    }

    public static class Builder extends JwtTokenHelper.AbstractTokenJwtBuilder<MobileToken> {

        public Builder() {
            this(JwtTokenHelper.readPrivateKey(PRIV_RESOURCE),SIGNATURE_ALGORITHM);
        }

        public Builder(Key key, SignatureAlgorithm algorithm) {
            super(key, algorithm);
        }

        @Override
        protected void write(Map<String, Object> claims, MobileToken token) {
            claims.put(CLAIM_NAMES.VERIFY_MODE, token.getVerifyMode());
            claims.put(CLAIM_NAMES.MOBILE, token.getMobile());
            claims.put(CLAIM_NAMES.ISSUED_AT, token.getIssuedAt().toEpochMilli());
            claims.put(CLAIM_NAMES.EXPIRES_AT, token.getExpiresAt().toEpochMilli());
        }
    }





}
