package com.xunyi.beast.token;

import lombok.Getter;
import lombok.Setter;

import java.time.Instant;

@Getter @Setter
public class AppOnceToken {

    public static final String HEADER_NAME = "X-APP-TOKEN";


    private String appId;

    //随机数
    private String nonce;

    //发行
    private Instant issuedAt;

    public AppOnceToken() {
    }

    public AppOnceToken(String appId, String nonce, Instant issuedAt) {
        this.appId = appId;
        this.nonce = nonce;
        this.issuedAt = issuedAt;
    }

    public boolean isExpireAt(int seconds) {
        Instant validity = this.issuedAt.plusSeconds(seconds);
        return Instant.now().isBefore(validity);
    }
}
