/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.token.web;

import com.xunyi.beast.token.XYToken;
import com.xunyi.beast.token.support.XYTokenJwt;
import com.xunyi.beast.token.web.AbstractTokenArgumentResolver;
import com.xunyi.beast.token.web.MissingXYTokenException;
import com.xunyi.beast.token.web.XYTokenValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestBindingException;

public class XYTokenArgumentResolver
extends AbstractTokenArgumentResolver<XYTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(XYTokenArgumentResolver.class);
    private XYTokenJwt.Parser parser = new XYTokenJwt.Parser();

    public XYTokenArgumentResolver() {
        super("xy-token", XYTokenValue.class);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(XYTokenValue.class);
    }

    @Override
    public boolean isRequired(XYTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws MissingXYTokenException {
        throw new MissingXYTokenException(parameter);
    }

    @Override
    protected Object resolveToken(MethodParameter parameter, String tokenString) throws ServletRequestBindingException {
        XYToken xyToken = (XYToken)this.parser.parse(tokenString);
        if (Long.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return xyToken.getUid();
        }
        return xyToken;
    }
}

