/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.token.web;

import com.xunyi.beast.token.support.WXUserTokenCodec;
import com.xunyi.beast.token.user.WXUserToken;
import com.xunyi.beast.token.web.AbstractTokenArgumentResolver;
import com.xunyi.beast.token.web.WXUserTokenValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.MissingRequestCookieException;
import org.springframework.web.bind.ServletRequestBindingException;

public class WXUserTokenArgumentResolver
extends AbstractTokenArgumentResolver<WXUserTokenValue> {
    private static final Logger log = LoggerFactory.getLogger(WXUserTokenArgumentResolver.class);
    private static final String COOKIE_NAME = "wx-token";
    private final WXUserTokenCodec codec = new WXUserTokenCodec();

    public WXUserTokenArgumentResolver() {
        super(COOKIE_NAME, WXUserTokenValue.class);
    }

    @Override
    public boolean isRequired(WXUserTokenValue annotation) {
        return annotation.required();
    }

    @Override
    protected void handleMissingValue(MethodParameter parameter) throws ServletRequestBindingException {
        throw new MissingRequestCookieException(COOKIE_NAME, parameter);
    }

    @Override
    protected Object resolveToken(MethodParameter parameter, String tokenString) throws ServletRequestBindingException {
        WXUserToken wxUserToken = (WXUserToken)this.codec.decode(tokenString);
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return wxUserToken.getOpenId();
        }
        return wxUserToken;
    }
}

