/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.token.web;

import java.lang.annotation.Annotation;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.MethodArgumentConversionNotSupportedException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public abstract class AbstractTokenArgumentResolver<A extends Annotation>
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractTokenArgumentResolver.class);
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private Class<A> annotationClass;
    private String cookieName;

    public AbstractTokenArgumentResolver(String cookieName, Class<A> annotationClass) {
        this.annotationClass = annotationClass;
        this.cookieName = cookieName;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(this.annotationClass);
    }

    public abstract boolean isRequired(A var1);

    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        MethodParameter nestedParameter;
        Object arg;
        Annotation annotation = parameter.getParameterAnnotation(this.annotationClass);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)("No " + this.annotationClass.getSimpleName() + " annotation"));
        String name = parameter.getParameterName();
        if (name == null) {
            name = "";
        }
        if ((arg = this.resolveValue(nestedParameter = parameter.nestedIfOptional(), webRequest)) == null) {
            if (this.isRequired(annotation) && !nestedParameter.isOptional()) {
                this.handleMissingValue(parameter);
            }
            arg = this.handleNullValue(arg, nestedParameter.getNestedParameterType());
        }
        if (binderFactory != null) {
            WebDataBinder binder = binderFactory.createBinder(webRequest, null, name);
            try {
                arg = binder.convertIfNecessary(arg, parameter.getParameterType(), parameter);
            }
            catch (ConversionNotSupportedException ex) {
                throw new MethodArgumentConversionNotSupportedException(arg, ex.getRequiredType(), name, parameter, ex.getCause());
            }
            catch (TypeMismatchException ex) {
                throw new MethodArgumentTypeMismatchException(arg, ex.getRequiredType(), name, parameter, ex.getCause());
            }
        }
        return arg;
    }

    protected abstract void handleMissingValue(MethodParameter var1) throws ServletRequestBindingException;

    @Nullable
    private Object handleNullValue(@Nullable Object value, Class<?> paramType) {
        if (value == null && Boolean.TYPE.equals(paramType)) {
            return Boolean.FALSE;
        }
        return value;
    }

    protected abstract Object resolveToken(MethodParameter var1, String var2) throws ServletRequestBindingException;

    @Nullable
    private Object resolveValue(MethodParameter parameter, NativeWebRequest webRequest) throws ServletRequestBindingException {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        Assert.state((servletRequest != null ? 1 : 0) != 0, (String)"No HttpServletRequest");
        Cookie cookieValue = WebUtils.getCookie((HttpServletRequest)servletRequest, (String)this.cookieName);
        if (cookieValue == null) {
            return null;
        }
        String tokenString = this.urlPathHelper.decodeRequestString(servletRequest, cookieValue.getValue());
        return this.resolveToken(parameter, tokenString);
    }
}

