/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.token.user;

import com.xunyi.beast.token.TokenNamed;
import java.time.Instant;

public class UserToken
implements TokenNamed {
    private String appId;
    private long uid;
    private Instant issuedAt;
    private Instant expiresAt;

    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }

    public void verify() {
        Instant now = Instant.now();
        if (this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new RuntimeException(msg);
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public long getUid() {
        return this.uid;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserToken)) {
            return false;
        }
        UserToken other = (UserToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        if (this.getUid() != other.getUid()) {
            return false;
        }
        Instant this$issuedAt = this.getIssuedAt();
        Instant other$issuedAt = other.getIssuedAt();
        if (this$issuedAt == null ? other$issuedAt != null : !((Object)this$issuedAt).equals(other$issuedAt)) {
            return false;
        }
        Instant this$expiresAt = this.getExpiresAt();
        Instant other$expiresAt = other.getExpiresAt();
        return !(this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        long $uid = this.getUid();
        result = result * 59 + (int)($uid >>> 32 ^ $uid);
        Instant $issuedAt = this.getIssuedAt();
        result = result * 59 + ($issuedAt == null ? 43 : ((Object)$issuedAt).hashCode());
        Instant $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        return result;
    }
}

