/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.token.support;

import com.xunyi.beast.token.EmailToken;
import com.xunyi.beast.token.support.AbstractTokenJwt;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.time.Instant;
import java.util.Map;

public class EmailTokenJwt
extends AbstractTokenJwt<EmailToken> {
    private static final String PRIV_RESOURCE = "classpath:token/email-token-private.der";
    private static final String PUB_RESOURCE = "classpath:token/email-token-public.der";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;

    private EmailTokenJwt() {
    }

    public static class Builder
    extends AbstractTokenJwt.AbstractTokenJwtBuilder<EmailToken> {
        public Builder() {
            this(AbstractTokenJwt.readPrivateKey(EmailTokenJwt.PRIV_RESOURCE), SIGNATURE_ALGORITHM);
        }

        public Builder(Key key, SignatureAlgorithm algorithm) {
            super(key, algorithm);
        }

        @Override
        protected void write(Map<String, Object> claims, EmailToken token) {
            claims.put("email", token.getEmail());
            claims.put("iss", token.getIssuedAt().toEpochMilli());
            claims.put("exp", token.getExpiresAt().toEpochMilli());
        }
    }

    public static class Parser
    extends AbstractTokenJwt.AbstractTokenJwtParser<EmailToken> {
        public Parser() {
            this(AbstractTokenJwt.readPublicKey(EmailTokenJwt.PUB_RESOURCE));
        }

        public Parser(Key key) {
            super(key);
        }

        @Override
        protected EmailToken read(Claims claims) {
            EmailToken token = new EmailToken();
            token.setEmail((String)claims.get("email", String.class));
            token.setIssuedAt(Instant.ofEpochMilli((Long)claims.get("iss", Long.class)));
            token.setExpiresAt(Instant.ofEpochMilli((Long)claims.get("exp", Long.class)));
            token.verify();
            return token;
        }
    }

    private static final class CLAIM_NAMES {
        private static final String EMAIL = "email";
        private static final String ISSUED_AT = "iss";
        private static final String EXPIRES_AT = "exp";

        private CLAIM_NAMES() {
        }
    }
}

