package com.xunyi.beast.token.web;

import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestBindingException;

public class InvalidXYTokenException extends ServletRequestBindingException {

    private final MethodParameter parameter;

    public InvalidXYTokenException(MethodParameter parameter) {
        super("");
        this.parameter = parameter;
    }

    @Override
    public String getMessage() {
        return "Invalid XYToken or method parameter of type " + this.parameter.getNestedParameterType().getSimpleName();
    }

    public MethodParameter getParameter() {
        return parameter;
    }
}
