package com.xunyi.beast.token;


import lombok.Getter;
import lombok.Setter;

import java.time.Instant;
import java.util.Objects;

/**
 * Token 包装
 * parse
 * 基础信息维护
 */
@Getter @Setter
public class XYToken implements TokenNamed {

    public static final String NAME = "XYToken";
    public static final String COOKIE_NAME = "xy-token";

    private long uid;

    private Instant issuedAt;

    private Instant expiresAt;

    public XYToken() {

    }

    /**
     *
     */
    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }

    /**
     * 是否有效
     */
    public void verify() {
        Instant now = Instant.now();
        if (this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new RuntimeException(msg);
        };
    }


    @Override
    public int hashCode() {
        return Objects.hash(uid, issuedAt, expiresAt);
    }

    @Override
    public String name() {
        return NAME;
    }
}
