/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.token;

import com.xunyi.beast.token.TokenNamed;
import java.time.Instant;
import java.util.Objects;

public class XYToken
implements TokenNamed {
    public static final String NAME = "XYToken";
    public static final String COOKIE_NAME = "xy-token";
    private long uid;
    private Instant issuedAt;
    private Instant expiresAt;

    private boolean verifyExp(Instant exp, Instant now) {
        return exp.isAfter(now);
    }

    public void verify() {
        Instant now = Instant.now();
        if (this.verifyExp(this.expiresAt, now)) {
            String msg = "token expired at " + this.getExpiresAt() + ". Current time: " + now;
            throw new RuntimeException(msg);
        }
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.issuedAt, this.expiresAt);
    }

    @Override
    public String name() {
        return NAME;
    }

    public long getUid() {
        return this.uid;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public void setUid(long uid) {
        this.uid = uid;
    }

    public void setIssuedAt(Instant issuedAt) {
        this.issuedAt = issuedAt;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }
}

