/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.token.web;

import com.xunyi.beast.token.support.XYTokenJwt;
import com.xunyi.beast.token.web.InvalidXYTokenException;
import com.xunyi.beast.token.web.MissingXYTokenException;
import com.xunyi.beast.token.web.XYTokenValue;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.MethodArgumentConversionNotSupportedException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class XYTokenArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(XYTokenArgumentResolver.class);
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private XYTokenJwt.Parser parser = new XYTokenJwt.Parser();

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(XYTokenValue.class);
    }

    public Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        MethodParameter nestedParameter;
        Object arg;
        XYTokenValue annotation = (XYTokenValue)parameter.getParameterAnnotation(XYTokenValue.class);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)"No XYTokenValue annotation");
        String name = parameter.getParameterName();
        if (name == null) {
            name = "";
        }
        if ((arg = this.resolveValue(nestedParameter = parameter.nestedIfOptional(), webRequest)) == null) {
            if (annotation.required() && !nestedParameter.isOptional()) {
                this.handleMissingValue(parameter);
            }
            arg = this.handleNullValue(arg, nestedParameter.getNestedParameterType());
        }
        if (binderFactory != null) {
            WebDataBinder binder = binderFactory.createBinder(webRequest, null, name);
            try {
                arg = binder.convertIfNecessary(arg, parameter.getParameterType(), parameter);
            }
            catch (ConversionNotSupportedException ex) {
                throw new MethodArgumentConversionNotSupportedException(arg, ex.getRequiredType(), name, parameter, ex.getCause());
            }
            catch (TypeMismatchException ex) {
                throw new MethodArgumentTypeMismatchException(arg, ex.getRequiredType(), name, parameter, ex.getCause());
            }
        }
        return arg;
    }

    private void handleMissingValue(MethodParameter parameter) throws MissingXYTokenException {
        throw new MissingXYTokenException(parameter);
    }

    @Nullable
    private Object handleNullValue(@Nullable Object value, Class<?> paramType) {
        if (value == null && Boolean.TYPE.equals(paramType)) {
            return Boolean.FALSE;
        }
        return value;
    }

    @Nullable
    private Object resolveValue(MethodParameter parameter, NativeWebRequest webRequest) throws InvalidXYTokenException {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        Assert.state((servletRequest != null ? 1 : 0) != 0, (String)"No HttpServletRequest");
        Cookie cookieValue = WebUtils.getCookie((HttpServletRequest)servletRequest, (String)"xy-token");
        if (cookieValue == null) {
            return null;
        }
        String xyTokenString = this.urlPathHelper.decodeRequestString(servletRequest, cookieValue.getValue());
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return xyTokenString;
        }
        try {
            return this.parser.parse(xyTokenString);
        }
        catch (Exception e) {
            log.warn("token [{}] parse  exception", (Object)xyTokenString, (Object)e);
            throw new InvalidXYTokenException(parameter);
        }
    }
}

