/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.token.support;

import com.xunyi.beast.token.XYToken;
import com.xunyi.beast.token.support.AbstractTokenJwt;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.time.Instant;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XYTokenJwt
extends AbstractTokenJwt<XYToken> {
    private static final Logger log = LoggerFactory.getLogger(XYTokenJwt.class);
    public static final String PRIV_RESOURCE = "classpath:xy-token-private.der";
    public static final String PUB_RESOURCE = "classpath:xy-token-public.der";
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM = SignatureAlgorithm.RS256;

    public static class Builder
    extends AbstractTokenJwt.AbstractTokenJwtBuilder<XYToken> {
        public Builder() {
            this(AbstractTokenJwt.readPrivateKey(XYTokenJwt.PRIV_RESOURCE), SIGNATURE_ALGORITHM);
        }

        public Builder(Key key, SignatureAlgorithm algorithm) {
            super(key, algorithm);
        }

        @Override
        protected void write(Map<String, Object> claims, XYToken token) {
            claims.put("xy-uid", token.getUid());
            claims.put("iss", token.getIssuedAt().toEpochMilli());
            claims.put("exp", token.getExpiresAt().toEpochMilli());
        }
    }

    public static class Parser
    extends AbstractTokenJwt.AbstractTokenJwtParser<XYToken> {
        public Parser() {
            this(AbstractTokenJwt.readPublicKey(XYTokenJwt.PUB_RESOURCE));
        }

        public Parser(Key key) {
            super(key);
        }

        @Override
        protected XYToken read(Claims claims) {
            XYToken token = new XYToken();
            Long uid = (Long)claims.get("xy-uid", Long.class);
            Instant issuedAt = Instant.ofEpochMilli((Long)claims.get("iss", Long.class));
            Instant expiresAt = Instant.ofEpochMilli((Long)claims.get("exp", Long.class));
            token.setUid(uid);
            token.setIssuedAt(issuedAt);
            token.setExpiresAt(expiresAt);
            return token;
        }
    }

    private static final class CLAIM_NAMES {
        public static final String UID = "xy-uid";
        public static final String ISSUED_AT = "iss";
        public static final String EXPIRES_AT = "exp";

        private CLAIM_NAMES() {
        }
    }
}

