package com.xunyi.beast.validator.constraints;


import com.xunyi.beast.validator.constraintvalidators.NoTabooValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@Documented
@Constraint(validatedBy = NoTabooValidator.class)
@Target({FIELD})
@Retention(RUNTIME)
public @interface NoTaboo {

    String message() default "含有敏感字";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default { };

}
