package com.xunyi.beast.sns.wechat.client;

import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.beast.sns.wechat.client.dto.AppOutput;
import com.xunyi.beast.sns.wechat.client.dto.JSConfigInput;
import com.xunyi.beast.sns.wechat.client.dto.JSConfigOutput;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.*;

@Service
@FeignClient("beast-sns-wechat")
public interface SNSWechatClient {

    @GetMapping("/api/apps/{app}")
    ReturnResult<AppOutput> app(
            @PathVariable("app") String app
    );

    @GetMapping("/api/apps/{app}/qrconnect-url")
    ReturnResult<String> qrconnectUrl(
            @PathVariable("app") String app,
            @RequestParam("redirectUri") String redirectUri
    );

    @GetMapping("/api/apps/{app}/authorize-url")
    ReturnResult<String> authorizeUrl(
            @PathVariable("app") String app,
            @RequestParam("redirectUri") String redirectUri
    );

    @GetMapping("/api/apps/{app}/user-credential")
    ReturnResult<WXUserCredential> getUserCredential(
            @PathVariable("app") String app,
            @RequestParam(name = "code") String code
    );

    @PostMapping("/api/apps/{app}/js/config")
    ReturnResult<JSConfigOutput> createJsConfig(
            @PathVariable("app") String app,
            @RequestBody JSConfigInput input
    );


}
