package com.xunyi.beast.sns.wechat.api.model.vo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Objects;

public enum WXMenuType {
    VIEW("view"),
    CLICK("click"),
    MINI_PROGRAM("mini_program"),


    ;
    private String value;

    WXMenuType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static WXMenuType valueOfKey(String value) {
        for (WXMenuType menuType : WXMenuType.values()) {
            if (Objects.equals(menuType.value, value)) {
                return menuType;
            }
        }
        return null;
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
