package com.xunyi.beast.sns.wechat.api.model;


import com.fasterxml.jackson.annotation.JsonProperty;
import com.xunyi.beast.sns.wechat.api.model.vo.GroupMessageMedia;
import com.xunyi.beast.sns.wechat.api.model.vo.MessageType;
import lombok.Getter;
import lombok.Setter;

import java.util.Map;

@Getter @Setter
public abstract class AbstractGroupMessage {
    //群发过滤
    private Filter filter;
    //消息标题
    private String title;
    //消息类型
    @JsonProperty("msgtype")
    private MessageType msgType;
    //
    private String description;
    private Map<MessageType, GroupMessageMedia> media;
    //
    private int sendIgnoreReprint;
    @Setter @Getter
    public class Filter {
        @JsonProperty("is_to_all")
        private boolean isToAll;
        @JsonProperty("tag_id")
        private String tagId;
    }
}
