package com.xunyi.beast.sns.wechat.api.support;

import com.xunyi.beast.sns.wechat.api.annotation.AddParameter;
import feign.MethodMetadata;
import org.springframework.cloud.openfeign.support.SpringMvcContract;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import static org.springframework.core.annotation.AnnotatedElementUtils.findMergedAnnotation;

public class WechatContract extends SpringMvcContract {
    @Override
    protected void processAnnotationOnMethod(MethodMetadata data,
                                             Annotation methodAnnotation, Method method) {
        super.processAnnotationOnMethod(data, methodAnnotation, method);

        if (!AddParameter.class.isInstance(methodAnnotation) && !methodAnnotation
                .annotationType().isAnnotationPresent(AddParameter.class)) {
            return;
        }

        AddParameter methodMapping = findMergedAnnotation(method, AddParameter.class);
        if (methodMapping != null) {
            data.template().query(methodMapping.name(), methodMapping.value());
        }
    }
}
