package com.xunyi.beast.sns.wechat.api.model.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 *
 * 不同类型的菜单所含的属性不一致，
 * 添加新的菜单类型时需对此进行修改
 * 如微信小程序需要添加appid，暂无
 */
@Getter
@Setter
public class WXMenuButton {

    /**
     * 菜单响应类型
     */
    private WXMenuType type;
    /**
     * 菜单标题
     */
    private String name;


    /**
     * 菜单key
     */
    private String key;

    private String url;

    private String mediaId;

    private String appId;

    @JsonProperty("pagepath")
    private String pagePath;

    /**
     *
     */
    @JsonProperty("sub_button")
    private List<WXMenuButton> buttons;

    @Override
    public String toString() {
        return "WXMenuButton{" +
                "type=" + type +
                ", name='" + name + '\'' +
                ", key='" + key + '\'' +
                ", url='" + url + '\'' +
                ", mediaId='" + mediaId + '\'' +
                ", appId='" + appId + '\'' +
                ", pagePath='" + pagePath + '\'' +
                ", buttons=" + buttons +
                '}';
    }
}