package com.xunyi.beast.sns.wechat.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;

@Getter @Setter
public class GetUserCredential extends ErrorMessage {

    /**
     * 获取到的凭证
     */
    @JsonProperty("access_token")
    private String accessToken;

    /**
     * 凭证有效时间，单位：秒   文档: 7200秒 于实际为准
     */
    @JsonProperty("expires_in")
    private long expiresIn;

    /**
     * 有效器为30天 如果已失效，则需用户重新授权
     */
    @JsonProperty("refresh_token")
    private String refreshToken;

    /**
     * 用户在该公众号下的唯一标识
     */
    private String openid;


    /**
     * 用户授权作用域 已逗号隔开 暂时忽略
     */
    private String scope;

}
