package com.xunyi.beast.sns.wechat.api;


import com.xunyi.beast.sns.wechat.api.model.*;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import com.xunyi.beast.sns.wechat.api.annotation.AddParameter;

public interface WeiXinClient {

    /**
     * 调用接口时，请登录“微信公众平台-开发-基本配置”提前将服务器IP地址添加到IP白名单中，点击查看设置方法，否则将无法调用成功
     * @link https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140183
     */
    @GetMapping("/cgi-bin/token")
    @AddParameter(name = "grant_type", value = "client_credential")
    GetClientCredential getCredential(
            @RequestParam(name = "appid") String appId,
            @RequestParam(name = "secret") String secret
    );

    /**
     * 根据code获取用户授权凭证
     * @param code 5分钟未被使用自动过期。
     * @link https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140842
     */
    @GetMapping("/sns/oauth2/access_token")
    @AddParameter(name = "grant_type", value = "authorization_code")
    GetUserCredential getUserCredential(
            @RequestParam(name = "appid") String appId,
            @RequestParam(name = "secret") String secret,
            @RequestParam(name = "code") String code
    );

    /**
     * 刷新用户授权凭证
     * @link https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140842
     */
    @GetMapping("/sns/oauth2/refresh_token")
    @AddParameter(name = "grant_type", value = "refresh_token")
    GetUserCredential refreshToken(
            @RequestParam(name = "appid") String appId,
            @RequestParam("refresh_token") String refreshToken
    );

    /**
     * 获取用户信息
     * @param accessToken 用户授权Token
     * @param lang: zh_CN
     * @link https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140842
     */
    @GetMapping("/cgi-bin/user/info")
    GetUserInfo getUserInfo(
            @RequestParam(name = "access_token") String accessToken,
            @RequestParam(name = "openid") String openid,
            @RequestParam(name = "lang") String lang
    );

    /**
     * 检验用户授权凭证
     * @param accessToken 用户授权Token
     * @link https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140842
     */
    @GetMapping("/sns/auth")
    ErrorMessage auth(
            @RequestParam(name = "access_token") String accessToken,
            @RequestParam(name = "openid") String openid
    );

    /**
     * 获取公众号菜单列表
     * @param accessToken 授权token
     * @link https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421141014
     */
    @GetMapping("/cgi-bin/menu/get")
    GetMenu getMenu(
            @RequestParam(name = "access_token") String accessToken
    );

    /**
     * 删除全部菜单（慎用，请注意，在个性化菜单时，调用此接口会删除默认菜单及全部个性化菜单）
     * @param accessToken 授权token
     * @link https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421141015
     */
    @GetMapping("cgi-bin/menu/delete")
    ErrorMessage deleteMenu(
            @RequestParam(name = "access_token") String accessToken
    );

    /**
     * 创建菜单
     * @link https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421141013
     */
    @PostMapping(value = "/cgi-bin/menu/create")
    ErrorMessage createMenu(
            @RequestParam(name = "access_token") String accessToken,
            @RequestBody CreateMenu createMenu
    );

    /**
     * 设置模板消息行业
     * @param accessToken
     * @return
     */
    @PostMapping("/cgi-bin/template/api_set_industry")
    ErrorMessage setIndustry(@RequestParam(name = "access_token") String accessToken,
                             @RequestBody MessageTemplateIndustry messageTemplateIndustry
    );

    /**
     * 获取模板ID
     * @param accessToken
     * @return
     */
    @GetMapping("/cgi-bin/template/get_all_private_template")
    TemplateIdResponse getTemplateId(@RequestParam(name = "access_token") String accessToken);

    /**
     * 发送模板消息
     * @param accessToken
     * @param messageTemplate
     * @return
     */
    @PostMapping("/cgi-bin/message/template/send")
    ErrorMessage sendTemplateMessage(@RequestParam(name = "access_token") String accessToken, @RequestBody MessageTemplateSend messageTemplate);

    /**
     * 群发消息
     * @param accessToken
     */
    @PostMapping("/cgi-bin/message/mass/sendall")
    ErrorMessage sendGroupMessage(@RequestParam(name = "access_token") String accessToken, @RequestBody AbstractGroupMessage groupMessage);

    /**
     * 获取订阅号用户列表
     * @param accessToken
     * @return
     */
    @GetMapping("/cgi-bin/user/get")
    WeixinUserList getUsers(@RequestParam(name = "access_token") String accessToken);

}
