package com.xunyi.beast.security.pry.policy;

import com.xunyi.beast.data.util.IPMatcher;
import com.xunyi.beast.security.pry.AccessContext;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.collections4.CollectionUtils;

import java.util.List;

@Getter @Setter
public class PryMapper {
    private String intent;
    private List<String> ips;
    private String policy;

    public boolean mapping(AccessContext accessContext) {
        String intent = this.getIntent();
        List<String> ips = this.getIps();

        if (!"*".equals(intent) && !intent.equals(accessContext.getIntent())) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(ips) && !IPMatcher.some(accessContext.getRealIP(), ips)) {
            return false;
        }
        return true;
    }
}
