package com.xunyi.beast.security.pry.configuration;

import com.google.common.base.Splitter;
import org.apache.logging.log4j.util.Strings;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapAdapter extends XmlAdapter<String, Map<String, String>> {


    @Override
    public Map<String, String> unmarshal(String v) throws Exception {
        Map<String, String> result = new HashMap<String, String>();
        Iterator<String> it = Splitter.on("\n").split(v).iterator();
        while (it.hasNext()) {
           String itemString = it.next();
            if (Strings.isBlank(itemString)) {
                continue;
            }
            String[] item = itemString.split("=");
            result.put(item[0].trim(), item[1].trim());
        }
        return result;
    }

    @Override
    public String marshal(Map<String, String> v) throws Exception {
        throw new UnsupportedOperationException();
    }

//    public static class MapBean {
//        private List<MapEntry> entries = new ArrayList<MapEntry>();
//
//        public void addEntry(MapEntry entry)
//        {
//            entries.add(entry);
//        }
//
//        public static class MapEntry {
//            public MapEntry()
//            {
//                super();
//            }
//
//            public MapEntry(Map.Entry<String, Object> entry)
//            {
//                super();
//                this.key = entry.getKey();
//                this.value = entry.getValue();
//            }
//
//            public MapEntry(String key, Object value)
//            {
//                super();
//                this.key = key;
//                this.value = value;
//            }
//
//            private String key;
//            private Object value;
//
//            public String getKey()
//            {
//                return key;
//            }
//
//            public void setKey(String key)
//            {
//                this.key = key;
//            }
//
//            public Object getValue()
//            {
//                return value;
//            }
//
//            public void setValue(Object value)
//            {
//                this.value = value;
//            }
//        }
//
//        public List<MapEntry> getEntries()
//        {
//            return entries;
//        }
//    }
}
