package com.xunyi.beast.security.access.predicate;

import org.springframework.beans.BeanUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

import java.util.List;
import java.util.function.Supplier;

public abstract class AbstractPredicateFactory<C> implements PredicateFactory<C>{

    private Class<C> configClass;

    public AbstractPredicateFactory() {
        this(null);
    }

    public AbstractPredicateFactory(Class<C> clazz) {
        if (clazz == null) {
            Class<?> factoryClass = this.getClass();
            List<TypeInformation<?>> arguments = ClassTypeInformation.from(factoryClass)
                    .getRequiredSuperTypeInformation(AbstractPredicateFactory.class)
                    .getTypeArguments();
            clazz = (Class<C>) resolveTypeParameter(arguments, 0,
                    () -> String.format("Could not resolve config type of %s!", factoryClass));
        }
        this.configClass = clazz;
    }
    private static Class<?> resolveTypeParameter(List<TypeInformation<?>> arguments, int index,
                                                 Supplier<String> exceptionMessage) {
        if (arguments.size() <= index || arguments.get(index) == null) {
            throw new IllegalArgumentException(exceptionMessage.get());
        }
        return arguments.get(index).getType();
    }

    @Override
    public Class<C> getConfigClass() {
        return configClass;
    }

    @Override
    public C newConfig() {
        return BeanUtils.instantiateClass(this.configClass);
    }

}
