package com.xunyi.beast.security.pry.configuration;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.kv.model.GetValue;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import java.io.Reader;
import java.io.StringReader;

public class ConsulPryPolicyDataSource implements PryPolicyDataSource{

    private JAXBContext jc;
    private ConsulClient client;
    private String key;

    public ConsulPryPolicyDataSource(ConsulClient client, String key)  {
        try {
            this.jc =  JAXBContext.newInstance(PryProperties.class);
        } catch (JAXBException e) {
            e.printStackTrace();
        }
        this.client = client;
        this.key = key;
    }

    @Override
    public PryProperties readProperties() throws JAXBException {
        GetValue getValue = client.getKVValue(this.key).getValue();
        if (getValue == null) {
            throw new IllegalStateException("consul key:" + this.key + " is not exist");
        }
        Reader reader = new StringReader(getValue.getDecodedValue());
        return (PryProperties) jc.createUnmarshaller().unmarshal(reader);
    }
}
