package com.xunyi.beast.security.auth.jackson;


import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xunyi.beast.security.auth.permission.WildcardPermission;

import java.io.IOException;

public class PermissionModule extends SimpleModule {

    public PermissionModule() {
        super(Version.unknownVersion());
        this.addSerializer(WildcardPermission.class, new ToStringSerializer(WildcardPermission.class));
        this.addDeserializer(WildcardPermission.class, new WildcardPermissionDeserializer());
    }


    public class WildcardPermissionDeserializer extends FromStringDeserializer<WildcardPermission> {

        protected WildcardPermissionDeserializer() {
            super(WildcardPermission.class);
        }

        @Override
        protected WildcardPermission _deserialize(String value, DeserializationContext ctxt) throws IOException {
            return new WildcardPermission(value);
        }
    }
}
