package com.xunyi.beast.security.access.predicate;
import com.xunyi.beast.security.access.AccessContext;

import java.util.function.Predicate;

public interface PredicateFactory<C> {

    default Class<C> getConfigClass() { throw new UnsupportedOperationException("getConfigClass() not implemented"); }

    default C newConfig() { throw new UnsupportedOperationException("newConfig() not implemented"); }

    Predicate<AccessContext> apply(C config);

    default String name() {return getClass().getSimpleName().replace(PredicateFactory.class.getSimpleName(), "");}

}