package com.xunyi.beast.security.access.predicate;

import com.xunyi.beast.data.ua.OperatingSystem;
import com.xunyi.beast.security.access.AccessContext;
import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.function.Predicate;

public class OperatingSystemPredicateFactory extends AbstractPredicateFactory<OperatingSystemPredicateFactory.Config>{


    @Override
    public Predicate<AccessContext> apply(Config config) {
        return new Predicate<AccessContext>() {
            @Override
            public boolean test(AccessContext context) {
                return config.operatingSystems.contains(context.getOperatingSystem());
            }
        };
    }

    @Getter
    @Setter
    public static class Config {

        private List<OperatingSystem> operatingSystems;

    }
}
