/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.security.pry;

import com.google.common.collect.Maps;
import com.xunyi.beast.security.pry.AccessContext;
import com.xunyi.beast.security.pry.PryContext;
import com.xunyi.beast.security.pry.policy.NonePryPolicy;
import com.xunyi.beast.security.pry.policy.PryMapper;
import com.xunyi.beast.security.pry.policy.PryPolicy;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PryService {
    private Map<PryMapper, PryPolicy> policyMap = Maps.newLinkedHashMap();
    private static NonePryPolicy NONE = new NonePryPolicy();

    public PryContext getPryContext(AccessContext accessContext) {
        PryPolicy match = this.getPolicy(accessContext);
        return new PryContext(accessContext, match);
    }

    public PryPolicy getPolicy(AccessContext accessContext) {
        PryPolicy match = NONE;
        for (PryMapper mapper : this.policyMap.keySet()) {
            if (!mapper.mapping(accessContext)) continue;
            match = this.policyMap.get(mapper);
            break;
        }
        return match;
    }

    public void configuration(List<PryMapper> mappers, Map<String, PryPolicy> policyMap) {
        LinkedHashMap mapperPolicyMap = Maps.newLinkedHashMap();
        for (PryMapper pryMapper : mappers) {
            String policyName = pryMapper.getPolicy();
            PryPolicy match = null;
            if ("none".equals(policyName.toLowerCase())) {
                match = NONE;
            } else {
                match = policyMap.get(policyName);
                if (match == null) {
                    throw new IllegalStateException(policyName + "not find");
                }
            }
            mapperPolicyMap.put(pryMapper, match);
        }
        this.policyMap = mapperPolicyMap;
    }
}

