/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.security.access.predicate;

import com.google.common.collect.Lists;
import com.xunyi.beast.security.access.AccessContext;
import com.xunyi.beast.security.access.predicate.AbstractPredicateFactory;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ipfilter.IpSubnetFilterRule;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

public class RemoteAddrPredicateFactory
extends AbstractPredicateFactory<Config> {
    @Override
    public Predicate<AccessContext> apply(Config config) {
        final List<IpSubnetFilterRule> sources = this.convert(config.sources);
        return new Predicate<AccessContext>(){

            @Override
            public boolean test(AccessContext context) {
                InetSocketAddress remoteAddress = context.getRemoteAddress();
                if (remoteAddress != null) {
                    for (IpSubnetFilterRule source : sources) {
                        if (!source.matches(remoteAddress)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @NotNull
    private List<IpSubnetFilterRule> convert(List<String> values) {
        ArrayList<IpSubnetFilterRule> sources = new ArrayList<IpSubnetFilterRule>();
        for (String arg : values) {
            this.addSource(sources, arg);
        }
        return sources;
    }

    private void addSource(List<IpSubnetFilterRule> sources, String source) {
        if (!((String)source).contains("/")) {
            source = (String)source + "/32";
        }
        String[] ipAddressCidrPrefix = ((String)source).split("/", 2);
        String ipAddress = ipAddressCidrPrefix[0];
        int cidrPrefix = Integer.parseInt(ipAddressCidrPrefix[1]);
        sources.add(new IpSubnetFilterRule(ipAddress, cidrPrefix, IpFilterRuleType.ACCEPT));
    }

    @Validated
    public static class Config {
        @NotEmpty
        private List<String> sources = Lists.newArrayList();

        public List<String> getSources() {
            return this.sources;
        }

        public void setSources(List<String> sources) {
            this.sources = sources;
        }
    }
}

