/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.security.access.predicate;

import com.xunyi.beast.security.access.AccessContext;
import com.xunyi.beast.security.access.predicate.AbstractPredicateFactory;
import java.util.function.Predicate;
import javax.validation.constraints.NotEmpty;
import org.springframework.util.AntPathMatcher;
import org.springframework.validation.annotation.Validated;

public class HostPredicateFactory
extends AbstractPredicateFactory<Config> {
    private AntPathMatcher pathMatcher = new AntPathMatcher(".");

    @Override
    public Predicate<AccessContext> apply(final Config config) {
        return new Predicate<AccessContext>(){

            @Override
            public boolean test(AccessContext context) {
                return HostPredicateFactory.this.pathMatcher.match(config.pattern, context.getHost());
            }
        };
    }

    @Validated
    public static class Config {
        @NotEmpty
        private String pattern;

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

