package com.xunyi.beast.route.predicate;

import com.xunyi.beast.data.ua.OperatingSystem;
import lombok.Getter;
import lombok.Setter;
import org.springframework.web.server.ServerWebExchange;

import java.util.List;
import java.util.function.Predicate;

public class OperatingSystemPredicateFactory extends AbstractPredicateFactory<OperatingSystemPredicateFactory.Config>{


    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        return new Predicate<ServerWebExchange>() {
            @Override
            public boolean test(ServerWebExchange exchange) {
                String userAgent = exchange.getRequest().getHeaders().getFirst("User-Agent");
                OperatingSystem operatingSystem = OperatingSystem.parseUserAgent(userAgent);
                return config.operatingSystems.contains(operatingSystem);
            }
        };
    }

    @Getter
    @Setter
    public static class Config {

        private List<OperatingSystem> operatingSystems;

    }
}
