package com.xunyi.beast.route.predicate;

import lombok.Getter;
import lombok.Setter;
import org.springframework.util.AntPathMatcher;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

import javax.validation.constraints.NotEmpty;
import java.util.function.Predicate;

public class HostPredicateFactory extends AbstractPredicateFactory<HostPredicateFactory.Config>{

    private AntPathMatcher pathMatcher = new AntPathMatcher(".");

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        return new Predicate<ServerWebExchange>() {
            @Override
            public boolean test(ServerWebExchange exchange) {
                String host = exchange.getRequest().getHeaders().getFirst("Host");
                return pathMatcher.match(config.pattern, host);
            }
        };
    }

    @Getter
    @Setter
    @Validated
    public static class Config {

        @NotEmpty
        private String pattern;
    }
}
