/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.route.predicate;

import com.xunyi.beast.data.ua.OperatingSystem;
import com.xunyi.beast.route.predicate.AbstractPredicateFactory;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.web.server.ServerWebExchange;

public class OperatingSystemPredicateFactory
extends AbstractPredicateFactory<Config> {
    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        return new Predicate<ServerWebExchange>(){

            @Override
            public boolean test(ServerWebExchange exchange) {
                String userAgent = exchange.getRequest().getHeaders().getFirst("User-Agent");
                OperatingSystem operatingSystem = OperatingSystem.parseUserAgent((String)userAgent);
                return config.operatingSystems.contains(operatingSystem);
            }
        };
    }

    public static class Config {
        private List<OperatingSystem> operatingSystems;

        public List<OperatingSystem> getOperatingSystems() {
            return this.operatingSystems;
        }

        public void setOperatingSystems(List<OperatingSystem> operatingSystems) {
            this.operatingSystems = operatingSystems;
        }
    }
}

