/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.route.predicate;

import com.google.common.collect.Lists;
import com.xunyi.beast.route.predicate.AbstractPredicateFactory;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ipfilter.IpSubnetFilterRule;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class RemoteAddrPredicateFactory
extends AbstractPredicateFactory<Config> {
    private static final Logger log = LoggerFactory.getLogger(RemoteAddrPredicateFactory.class);
    private final int maxTrustedIndex = Integer.MAX_VALUE;
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        final List<IpSubnetFilterRule> sources = this.convert(config.sources);
        return new Predicate<ServerWebExchange>(){

            @Override
            public boolean test(ServerWebExchange exchange) {
                InetSocketAddress remoteAddress = RemoteAddrPredicateFactory.this.resolve(exchange);
                if (remoteAddress != null) {
                    for (IpSubnetFilterRule source : sources) {
                        if (!source.matches(remoteAddress)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @NotNull
    private List<IpSubnetFilterRule> convert(List<String> values) {
        ArrayList<IpSubnetFilterRule> sources = new ArrayList<IpSubnetFilterRule>();
        for (String arg : values) {
            this.addSource(sources, arg);
        }
        return sources;
    }

    private void addSource(List<IpSubnetFilterRule> sources, String source) {
        if (!((String)source).contains("/")) {
            source = (String)source + "/32";
        }
        String[] ipAddressCidrPrefix = ((String)source).split("/", 2);
        String ipAddress = ipAddressCidrPrefix[0];
        int cidrPrefix = Integer.parseInt(ipAddressCidrPrefix[1]);
        sources.add(new IpSubnetFilterRule(ipAddress, cidrPrefix, IpFilterRuleType.ACCEPT));
    }

    public InetSocketAddress resolve(ServerWebExchange exchange) {
        List<String> xForwardedValues = this.extractXForwardedValues(exchange);
        Collections.reverse(xForwardedValues);
        if (!xForwardedValues.isEmpty()) {
            int index = Math.min(xForwardedValues.size(), Integer.MAX_VALUE) - 1;
            return new InetSocketAddress(xForwardedValues.get(index), 0);
        }
        return this.resolveRemoteAddress(exchange);
    }

    private InetSocketAddress resolveRemoteAddress(ServerWebExchange exchange) {
        return exchange.getRequest().getRemoteAddress();
    }

    private List<String> extractXForwardedValues(ServerWebExchange exchange) {
        List xForwardedValues = exchange.getRequest().getHeaders().get((Object)X_FORWARDED_FOR);
        if (xForwardedValues == null || xForwardedValues.isEmpty()) {
            return Collections.emptyList();
        }
        if (xForwardedValues.size() > 1) {
            log.warn("Multiple X-Forwarded-For headers found, discarding all");
            return Collections.emptyList();
        }
        List<String> values = Arrays.asList(((String)xForwardedValues.get(0)).split(", "));
        if (values.size() == 1 && !StringUtils.hasText((String)values.get(0))) {
            return Collections.emptyList();
        }
        return values;
    }

    @Validated
    public static class Config {
        @NotEmpty
        private List<String> sources = Lists.newArrayList();

        public List<String> getSources() {
            return this.sources;
        }

        public void setSources(List<String> sources) {
            this.sources = sources;
        }
    }
}

