/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.route.predicate;

import com.xunyi.beast.route.predicate.AbstractPredicateFactory;
import java.util.function.Predicate;
import javax.validation.constraints.NotEmpty;
import org.springframework.util.AntPathMatcher;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class HostPredicateFactory
extends AbstractPredicateFactory<Config> {
    private AntPathMatcher pathMatcher = new AntPathMatcher(".");

    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        return new Predicate<ServerWebExchange>(){

            @Override
            public boolean test(ServerWebExchange exchange) {
                String host = exchange.getRequest().getHeaders().getFirst("Host");
                return HostPredicateFactory.this.pathMatcher.match(config.pattern, host);
            }
        };
    }

    @Validated
    public static class Config {
        @NotEmpty
        private String pattern;

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

