/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.propagation.instrument.async;

import com.xunyi.beast.propagation.context.CurrentContext;
import com.xunyi.beast.propagation.instrument.async.ContextExecutor;
import com.xunyi.beast.propagation.instrument.async.ContextExecutorService;
import com.xunyi.beast.propagation.instrument.async.ExecutorMethodInterceptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class ExecutorBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ExecutorBeanPostProcessor.class);
    private List<String> ignoredBeans = new ArrayList<String>();
    private CurrentContext currentContext;

    public ExecutorBeanPostProcessor(CurrentContext currentContext) {
        this.currentContext = currentContext;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ContextExecutorService || bean instanceof ContextExecutor) {
            return bean;
        }
        if (this.ignoredBeans.contains(beanName)) {
            return bean;
        }
        if (bean instanceof ExecutorService) {
            return this.wrapExecutorService(bean);
        }
        return bean;
    }

    private Object wrapExecutorService(Object bean) {
        ExecutorService executorService = (ExecutorService)bean;
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean methodFinal = ExecutorBeanPostProcessor.anyFinalMethods(executorService, ExecutorService.class);
        boolean cglibProxy = !classFinal && !methodFinal;
        return this.createExecutorServiceProxy(bean, cglibProxy, executorService);
    }

    Object createExecutorServiceProxy(Object bean, boolean cglibProxy, ExecutorService executor) {
        return this.getProxiedObject(bean, cglibProxy, executor, () -> new ContextExecutorService(this.currentContext, executor));
    }

    private ProxyFactoryBean proxyFactoryBean(Object bean, boolean cglibProxy, Executor executor, final Supplier<Executor> supplier) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice((Advice)new ExecutorMethodInterceptor<Executor>(executor, this.currentContext){

            @Override
            Executor executor(CurrentContext currentContext, Executor executor) {
                return (Executor)supplier.get();
            }
        });
        factory.setTarget(bean);
        return factory;
    }

    Object getObject(ProxyFactoryBean factory) {
        return factory.getObject();
    }

    private Object getProxiedObject(Object bean, boolean cglibProxy, Executor executor, Supplier<Executor> supplier) {
        ProxyFactoryBean factory = this.proxyFactoryBean(bean, cglibProxy, executor, supplier);
        try {
            return this.getObject(factory);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("Exception occurred while trying to get a proxy. Will fallback to a different implementation", (Throwable)ex);
            }
            return supplier.get();
        }
    }

    private static <T> boolean anyFinalMethods(T object, Class<T> iface) {
        try {
            for (Method method : ReflectionUtils.getDeclaredMethods(iface)) {
                Method m = ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
                if (m == null || !Modifier.isFinal(m.getModifiers())) continue;
                return true;
            }
        }
        catch (IllegalAccessError er) {
            if (log.isDebugEnabled()) {
                log.debug("Error occurred while trying to access methods", (Throwable)er);
            }
            return false;
        }
        return false;
    }
}

