package com.xunyi.beast.propagation.shunt.group;

import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.PredicateKey;
import com.netflix.loadbalancer.Server;
import org.springframework.lang.Nullable;


/**
 * 服务组选择
 */
public class ServerGroupPredicate extends AbstractServerPredicate {

    private ServerGroupShunting shunting;

    public ServerGroupPredicate(@Nullable ServerGroupShunting shunting) {
        this.shunting = shunting;
    }

    @Override
    public boolean apply(@Nullable PredicateKey predicateKey) {
        if (predicateKey == null) {
            return false;
        }
        Server server = predicateKey.getServer();
        return shunting.apply(server);
    }

}
