/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.propagation.shunt;

import com.netflix.loadbalancer.PollingServerListUpdater;
import com.netflix.loadbalancer.ServerListUpdater;
import com.xunyi.beast.core.profile.Alpha;
import com.xunyi.beast.core.profile.Beta;
import com.xunyi.beast.core.profile.Prod;
import com.xunyi.beast.propagation.shunt.Shunt;
import com.xunyi.beast.propagation.shunt.group.ShuntingContextRule;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.ribbon.RibbonClientName;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class ShuntRibbonClientConfiguration {
    @RibbonClientName
    private String name = "client";

    @Beta
    @Alpha
    @Bean
    @ConditionalOnMissingBean
    public ServerListUpdater testRibbonServerListUpdater() {
        return new PollingServerListUpdater(1000L, 1000L);
    }

    @Prod
    @Bean
    @ConditionalOnMissingBean
    public ServerListUpdater ribbonServerListUpdater() {
        return new PollingServerListUpdater(1000L, 3000L);
    }

    @Bean
    @ConditionalOnBean(value={Shunt.class})
    @ConditionalOnMissingBean
    public ShuntingContextRule shuntingRule() {
        return new ShuntingContextRule();
    }
}

