package com.xunyi.beast.propagation.shunt.group;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.*;
import com.xunyi.beast.propagation.shunt.Shunt;
import com.xunyi.beast.propagation.shunt.propagation.ShuntContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ShuntingContextRule extends PredicateBasedRule {


    private Shunt shunt;

    private PriorityPredicatePredicate priorityPredicatePredicate;

    public ShuntingContextRule() {
        super();
        this.priorityPredicatePredicate = createPredicate();
    }

    @Override
    public void initWithNiwsConfig(IClientConfig clientConfig) {
        super.initWithNiwsConfig(clientConfig);
        //ZoneLoadBalance会clone 所以在此注入
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
    }

    public PriorityPredicatePredicate createPredicate() {
//        return CompositePredicate.withPredicate(new AbstractServerPredicate() {
//            @Override
//            public boolean apply(@Nullable PredicateKey predicateKey) {
////                return createShuntingPredicate().apply(predicateKey);
//                re
//            }
//        }).build();
        return new PriorityPredicatePredicate() {

            @Override
            public List<AbstractServerPredicate> getPredicates() {
                return createShuntingPredicates();
            }
        };
    };


    public List<AbstractServerPredicate> createShuntingPredicates() {
        //获取当前分流上下文规则 并
        ShuntContext context = this.shunt.currentShuntContext()
                .get();
        if (context == null) {
            return Lists.newArrayList(AbstractServerPredicate.alwaysTrue());
        }

        List<String> sequence = context.sequences();

        //特征服务
        List<AbstractServerPredicate> predicates = sequence.stream().map(ServerGroupShunting::new).map(ServerGroupPredicate::new).collect(Collectors.toList());

        //正常服务
        predicates.add(new ServerGroupPredicate(new ServerGroupShunting("standard")));
        predicates.add(new EmptyServerGroupPredicate());

        return predicates;
//        Iterator<AbstractServerPredicate> it = predicates.iterator();
//        CompositePredicate.Builder builder = CompositePredicate.withPredicate(it.next());
//        while (it.hasNext()) {
//            builder.addFallbackPredicate(it.next());
//        }
//        return builder.build();
    }



    @Override
    public Server choose(Object key) {
        ILoadBalancer lb = getLoadBalancer();
//        lb.getAllServers();

        Optional<Server> server = getPredicate().chooseRoundRobinAfterFiltering(lb.getAllServers(), key);
        if (server.isPresent()) {
            return server.get();
        } else {
            return null;
        }
    }

    @Override
    public AbstractServerPredicate getPredicate() {
        return this.priorityPredicatePredicate;
    }

    @Autowired
    public void setShunt(Shunt shunt) {
        this.shunt = shunt;
    }
}


